/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.blockentity;

import com.min01.archaeology.blockentity.DecoratedPotBlockEntity;
import com.min01.archaeology.misc.DecoratedPotPatterns;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DecoratedPotRenderer
implements BlockEntityRenderer<DecoratedPotBlockEntity> {
    private static final String NECK = "neck";
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private final Material baseMaterial = Objects.requireNonNull(DecoratedPotRenderer.getDecoratedPotMaterial(DecoratedPotPatterns.BASE));
    public static final ModelLayerLocation DECORATED_POT_BASE = new ModelLayerLocation(new ResourceLocation("decorated_pot_base"), "main");
    public static final ModelLayerLocation DECORATED_POT_SIDES = new ModelLayerLocation(new ResourceLocation("decorated_pot_sides"), "main");
    public static final ResourceLocation DECORATED_POT_SHEET = InventoryMenu.f_39692_;
    public static final Map<ResourceKey<String>, Material> DECORATED_POT_MATERIALS = DecoratedPotPatterns.bootstrap().stream().collect(Collectors.toMap(Function.identity(), DecoratedPotRenderer::createDecoratedPotMaterial));

    public DecoratedPotRenderer(BlockEntityRendererProvider.Context p_272872_) {
        ModelPart modelpart = p_272872_.m_173582_(DECORATED_POT_BASE);
        this.neck = modelpart.m_171324_(NECK);
        this.top = modelpart.m_171324_(TOP);
        this.bottom = modelpart.m_171324_(BOTTOM);
        ModelPart modelpart1 = p_272872_.m_173582_(DECORATED_POT_SIDES);
        this.frontSide = modelpart1.m_171324_(FRONT);
        this.backSide = modelpart1.m_171324_(BACK);
        this.leftSide = modelpart1.m_171324_(LEFT);
        this.rightSide = modelpart1.m_171324_(RIGHT);
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubedeformation = new CubeDeformation(0.2f);
        CubeDeformation cubedeformation1 = new CubeDeformation(-0.1f);
        partdefinition.m_171599_(NECK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, cubedeformation1).m_171514_(0, 5).m_171488_(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, cubedeformation), PartPose.m_171423_((float)0.0f, (float)37.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(-14, 13).m_171481_(0.0f, 0.0f, 0.0f, 14.0f, 0.0f, 14.0f);
        partdefinition.m_171599_(TOP, cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(BOTTOM, cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createSidesLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(1, 0).m_171481_(0.0f, 0.0f, 0.0f, 14.0f, 16.0f, 0.0f);
        partdefinition.m_171599_(BACK, cubelistbuilder, PartPose.m_171423_((float)15.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partdefinition.m_171599_(LEFT, cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)-1.5707964f, (float)((float)Math.PI)));
        partdefinition.m_171599_(RIGHT, cubelistbuilder, PartPose.m_171423_((float)15.0f, (float)16.0f, (float)15.0f, (float)0.0f, (float)1.5707964f, (float)((float)Math.PI)));
        partdefinition.m_171599_(FRONT, cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)15.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Nullable
    private static Material getMaterial(Item p_272698_) {
        Material material = DecoratedPotRenderer.getDecoratedPotMaterial(DecoratedPotPatterns.getResourceKey(p_272698_));
        if (material == null) {
            material = DecoratedPotRenderer.getDecoratedPotMaterial(DecoratedPotPatterns.getResourceKey(Items.f_42460_));
        }
        return material;
    }

    private static Material createDecoratedPotMaterial(ResourceKey<String> p_272805_) {
        return new Material(DECORATED_POT_SHEET, DecoratedPotPatterns.location(p_272805_));
    }

    @Nullable
    public static Material getDecoratedPotMaterial(@Nullable ResourceKey<String> p_273567_) {
        return p_273567_ == null ? null : DECORATED_POT_MATERIALS.get(p_273567_);
    }

    public void render(DecoratedPotBlockEntity p_273776_, float p_273103_, PoseStack p_273455_, MultiBufferSource p_273010_, int p_273407_, int p_273059_) {
        p_273455_.m_85836_();
        Direction direction = p_273776_.getDirection();
        p_273455_.m_85837_(0.5, 0.0, 0.5);
        p_273455_.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - direction.m_122435_()));
        p_273455_.m_85837_(-0.5, 0.0, -0.5);
        VertexConsumer vertexconsumer = this.baseMaterial.m_119194_(p_273010_, RenderType::m_110446_);
        this.neck.m_104301_(p_273455_, vertexconsumer, p_273407_, p_273059_);
        this.top.m_104301_(p_273455_, vertexconsumer, p_273407_, p_273059_);
        this.bottom.m_104301_(p_273455_, vertexconsumer, p_273407_, p_273059_);
        DecoratedPotBlockEntity.Decorations decoratedpotblockentity$decorations = p_273776_.getDecorations();
        this.renderSide(this.frontSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getMaterial(decoratedpotblockentity$decorations.front()));
        this.renderSide(this.backSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getMaterial(decoratedpotblockentity$decorations.back()));
        this.renderSide(this.leftSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getMaterial(decoratedpotblockentity$decorations.left()));
        this.renderSide(this.rightSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getMaterial(decoratedpotblockentity$decorations.right()));
        p_273455_.m_85849_();
    }

    private void renderSide(ModelPart p_273495_, PoseStack p_272899_, MultiBufferSource p_273582_, int p_273242_, int p_273108_, @Nullable Material p_273173_) {
        if (p_273173_ == null) {
            p_273173_ = DecoratedPotRenderer.getMaterial(Items.f_42460_);
        }
        if (p_273173_ != null) {
            p_273495_.m_104301_(p_272899_, p_273173_.m_119194_(p_273582_, RenderType::m_110446_), p_273242_, p_273108_);
        }
    }
}

